/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.google.common.collect.Iterators;
import com.simibubi.create.foundation.render.BlockEntityRenderHelper;
import com.simibubi.create.foundation.utility.fabric.SingleRenderTypeSbbBuilder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.client.render.model.BakedModelBufferer;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class SchematicRenderer {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final Map<class_1921, SuperByteBuffer> bufferCache = new LinkedHashMap<class_1921, SuperByteBuffer>();
    private boolean changed;
    protected final SchematicLevel schematic;
    private final class_2338 anchor;
    private final List<class_2586> renderedBlockEntities = new ArrayList<class_2586>();
    private final BitSet shouldRenderBlockEntities = new BitSet();
    private final BitSet scratchErroredBlockEntities = new BitSet();

    public SchematicRenderer(SchematicLevel world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.changed = true;
        for (class_2586 renderedBlockEntity : this.schematic.getRenderedBlockEntities()) {
            this.renderedBlockEntities.add(renderedBlockEntity);
        }
        this.shouldRenderBlockEntities.set(0, this.renderedBlockEntities.size());
    }

    public void update() {
        this.changed = true;
    }

    public void render(class_4587 ms, SuperRenderTypeBuffer buffers) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        if (this.changed) {
            this.redraw();
        }
        this.changed = false;
        this.bufferCache.forEach((layer, buffer) -> buffer.renderInto(ms, buffers.getBuffer(layer)));
        this.scratchErroredBlockEntities.clear();
        BlockEntityRenderHelper.renderBlockEntities(this.renderedBlockEntities, this.shouldRenderBlockEntities, this.scratchErroredBlockEntities, null, (class_1937)this.schematic, ms, null, (class_4597)buffers, AnimationTickHolder.getPartialTicks());
        this.shouldRenderBlockEntities.andNot(this.scratchErroredBlockEntities);
    }

    protected void redraw() {
        this.bufferCache.clear();
        for (class_1921 layer : class_1921.method_22720()) {
            SuperByteBuffer buffer = this.drawLayer(layer);
            if (buffer.isEmpty()) continue;
            this.bufferCache.put(layer, buffer);
        }
    }

    protected SuperByteBuffer drawLayer(class_1921 layer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        SingleRenderTypeSbbBuilder sbbBuilder = objects.sbbBuilder;
        class_4587 poseStack = objects.poseStack;
        class_2338.class_2339 reusedPos = objects.mutableBlockPos;
        class_3341 bounds = this.schematic.getBounds();
        sbbBuilder.prepare(layer);
        this.schematic.renderMode = true;
        Iterator positions = Iterators.transform(class_2338.method_23627((class_3341)bounds).iterator(), pos -> reusedPos.method_35831((class_2382)Objects.requireNonNull(pos), (class_2382)this.anchor));
        BakedModelBufferer.bufferBlocks((Iterator)positions, (class_1920)this.schematic, (class_4587)poseStack, (boolean)true, (ShadeSeparatedResultConsumer)sbbBuilder);
        this.schematic.renderMode = false;
        return sbbBuilder.build();
    }

    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        public final SingleRenderTypeSbbBuilder sbbBuilder = new SingleRenderTypeSbbBuilder();

        private ThreadLocalObjects() {
        }
    }
}

